-------------
-- GLOBALS --
-------------
assert(DynamicCam)


------------
-- LOCALS --
------------
local presets = {

  ["Immersive"] = {
    author = "LudiusMaximus",
    description = "Some settings to make gameplay more immersive:\n-Slight shoulder offset, but not while in dungeons/raids.\n-Go to view 2 during NPC/Mailbox interaction.\n-Go to view 3 and start rotating when teleporting.\n\nNOTICE: You have to setup the views yourself! E.g. while interacting with an NPC, put the camera into a position you like, then type '/sv 2' into the console to store it. Similarly, find a good camera view facing your character from the right and type '/sv 3' to store it as the teleport start view.",
    importString = "dqZwjaGEQe7sjABujXmPskZgLUPOQUnQ2jk2lz3c9tG0FbPFlXqbkdxQehuuPJjkNtQKAHavlvQKSyalxXdLQ6PuEmv9CbtKkyQszYGA6qxei0HrUSQRljBKk0wPsTzPsTDL0NPI(gvsAAarFxQYWuQtlYObX4fvCsjLZsLuDnPIZlQYYKuTwGGNPewzQjRltP7e7vtg87MQyX(R0eutg(ac1t8pKd5fjEYdwc9qaNc3XYkyeSy2lDvz4diupX)qoKxK4jpyj0drmzYWhqOEI)HCiViXtEWsOhc4u4owwbJGDO0lAEI9Ijtg(ac1t8pKd5fjEYdwc9qmoniyP1c2VclD3TdPakMTm8beQN4FihYls8KhSe6HaofUJLvWiyhzZlfDkM9YUUJmpX)qGqPWTU8dlMoBHYw)esLOyQlBo5X06bHsHRMShja2dlWLrWW1I(58hXGyYw2rgNYbekfElXVy2lZKrWW1I(58hXqUS9O8cIzllf95cd7qQ7U)8O)IPUqzDNMa2vvrbilKWkctLyqnzl2lutOS9IfQj7rcG9WcqOSD9fQj7rcG9WcqOS92vut2Jea7HfGqzl21vt2Jea7HfGqz7fzQj7rcG9WcqOSSDMAYEKaypSaekBVRRMmpX)q9Dttqnz4diupX)qGU(XGuQyH)iMSL1fkZt8puUEmvIb1K5sPWDtSvxmDKHdfdjmvITe)IjBzhzyI)AH8PCeGmxkfUDetrNYsrHcLTxSvtMN4FO(UPjOMm8beQN4Fiqx)yqkvSWFeZwOqz76B1K5j(hQVBAcQjdFaH6j(hc01pgKsfl8hXSfk7rcG9WcqOSSDD1K9ibWEybiu2UZwnzEI)H67MMGAYWhqOEI)HaD9JbPuXc)rmBHcLvFNPMShja2dlaHYwSZut2A69ut2Jea7Hf4YwtVhtfh4JyQlBEalZDNEpbUqzEI)H67MMGAYWhqOEI)HaD9JbPuXc)rmzYWhqOEI)HA048OJfFvOwe)qEeeJea7ftMm8beQN4FOgnop6yXxfQfXpKhnCE0jcbSe6HiMmz4diupX)qnACE0XIVkulIFipA48OteIRt9etMqzEI)HY1JPsmOMmmXFTq(uocqOqzBxzRMmpX)q9Dttqnz4diupX)qGU(XGuQyH)iMTqHY2laPAYEKaypSaekBxptnzpsaShwacLT3GunzEI)H67MMGAYWhqOEI)HaD9JbPuXc)rmzl7iuMN4FOC9yQedQjZLsH7MyRUyYaPmCOyiHPsSL4xmzl7idt8xlKpLJaK5sPWTJyk6uwPcfku2ENPMmpX)q9Dttqnz4diupX)qGU(XGuQyH)iMSLDekZt8puUEmvIb1K5sPWDtSvxmzGugoumKWuj2s8lMSLDKHj(RfYNYraYCPu42rmfDkRuHcfkBxhKQj7rcG9WcqOSDNm1K9ibWEybiu22vYut2Jea7HfGqzl2B1KTMEp1K9ibWEybUS107XuXb(iM6YMhWYC3P3tGluMN4FOC9yQedQjdt8xlKpLJaekZt8puF30eutg(ac1t8peORFmiLkw4pIjBzhz4diupX)qnACE0XIVkulIFipcIrcG9Ijtg(ac1t8puJgNhDS4Rc1I4hYJgop6eHawc9qetMm8beQN4FOgnop6yXxfQfXpKhnCE0jcX1PEIjtOqz13B1KTMEp1K9ibWEybUS107XuXb(iMfYMhWYC3P3tGluMN4FOC9yQedQjdhkgsyQeBj(ftMmmXFTq(uocq2uqcVDetrNYGVZ5piZLsHBhXu0PSWrz5r9C4oN)GyQ7QBztbj8cCzUukC3eB1fdiL1Le6H4WDo)bXK1rOmpX)q9Dttqnz4diupX)qGU(XGuQyH)iMTqHYY2B1K9ibWEybiu2E3rnzEI)H67MMGAYWhqOEI)HaD9JbPuXc)rmzlRluMN4FOC9yQedQjZLsH7MyRUy6idhkgsyQeBj(ft2YoYWe)1c5t5iazUukC7iMIoLLIcfklBVqnzpsaShwacfkJGxPO)WcCHYW86YL5qFOG1vG6ynxdeLfj(LvJZ)esRxgvHqkJmxRcovfYNYjXRccLaa",
  },

  ["Shushudaa's preset"] = {
    author = "Shushudaa",
    description = "A zoomed-in experience with lots of rotations to make the most of ActionCam. Little to no head tracking.",
    importString = "da0czaWjQeKMLuYTOsKDjLAys1XeQLrqpJKAAeW1OsTnjX3ijghjPZjqEhvIk3JkbYbjqwij4HujnrkLlkGnsiJKa1jLqntQeOUPa1or0pLKAOi0sPsuEQOPsjxLkb1wjHwlvcO9Q8xQyWsWHrTykvpwLjJGld2SKKplfJwsDAQ61ujQA2c62iTBk(nrdxcXYv1Zj10HUUeTDs03LqA8uj05juRxiEpvcW9PsqSFH0lEwllYlRYhcZAjbOkUmeDvj)6zTebn6CmfE2Mydt9hrpE1kWAqKujrMWi7T7QUebn6CmfEwWatiyPsGcg0LXMgipoegPalrqJohtHNTj2Wu)r0JxDs5hj6vkrxlrzvvzZRXr2xIGgDoMcpBtSHP(JOhVAfynisQKitWMSOM84qyK9LiOrNJPWZ2eByQ)i6XREKXlrqJohtHNRwj8zTSmKa8JmUD8se0OZXu4zBInm1Fe94vRaRbrsLezcIcf7nnJS3wGklpMcp7cukPzraGWifg0WLkHx7LMrkCzv(xJUSsZSVu7Xsg9sJEwlv3vpRHlJ7QN1YJPWZc6qV0ON1s8zJ2JEPXYtHrgVmIustarVPzPSexgrkPkYHLWiJvpC5Xu4zxvKF9SwIGgDoMcpBtSHP(JOhVAfynisQKityK92QxIGgDoMcpBtSHP(JOhV6rgVebn6CmfEwWatiyPsGcgmXhmny9i7TfyjcA05yk8SnXgM6pIE8QvG1GiPsImbBYIAYJdHr2xIGgDoMcpBXFdGIKxPUydcpFyadBpegzFjcA05yk8Sf)naksEL6agGkoGHThcJSVebn6CmfEUALWN1YYqcWprQiS7wf3bjqxTkbju1U6vLl5w9se0OZXu4zBInm1Fe94vNu(rIELs01suwvv28ACKQ229WHl7cvpRLGHThceM9LhtHNf0HEPrpRLrKsQipsuQ9OxAgzL(YisjvKhTKnnHajtHIeYimfwgrkPjGO30SSkpUmIusdMDXrkSpC4YEVYSwEmfE2vf5xpRLiOrNJPWZ2eByQ)i6XRwbwdIKkjYegzVT7LiOrNJPWZvRe(Swwgsa(rg3w4se0OZXu4zbdmHGLkbkyWeFW0G1JS3UYse0OZXu4zl(BauK8k1bmavCadBpegzFjcA05yk8SnXgM6pIE8Qhz8se0OZXu4zBInm1Fe94vRaRbrsLezc2Kf1KhhcJS3wD8se0OZXu4zl(BauK8k1fBq45ddyy7HWi7lrqJohtHNTj2Wu)r0JxDs5hj6vkrxlrzvvzZRXrg3B7E4YJPWZc6qV0ON1s8zJ2JEPXYtHrg329Yisjny2fhzSalJiLurEKOu7rV0mYk9LrKsAWEZiJ7lJiLurE0vPb9gzPEkSmIustarVPzPgWHdxQUlCwlpMcplOd9sJEwlJiLuf5WsyKQSmIustarVPzPgWHlpMcp7QI8RN1se0OZXu4zBInm1Fe94vpY4LiOrNJPWZw83aOi5vQl2GWZhgWW2dHr2xIGgDoMcpBXFdGIKxPoGbOIdyy7HWi7dhUmUhpRLhtHNDvr(1ZAjcA05yk8Sf)naksEL6Ini88HbmS9qyK9LiOrNJPWZvRe(Swwgsa(rQUTQlrqJohtHNfmWecwQeOGbt8btdwpsHlrqJohtHNT4VbqrYRuhWauXbmS9qyK9HlpMcplOd9sJEwlJiL0eq0BAwQbC5lrgHPWYxImczraGWiJ7lJiLuf5WsyKXchUeCr8z9Sww7jaUWfpfgoCzxDFwlpMcp7QI8RN1se0OZXu4zl(BauK8k1fBq45ddyy7HWi7lrqJohtHNfmWecwQeOGbt8btdwpY(se0OZXu4zl(BauK8k1bmavCadBpegzFjcA05yk8SnXgM6pIE8QhzFjcA05yk8C1kHpRLLHeGFK9HllY7LVhfpYyH9LhtHNf0HEPrpRLrKsQICyjmsHQUmIustarVPzPgWHdx27cN1YJPWZUQi)6zTebn6CmfE2Mydt9hrpE1kWAqKujrMWi7TJJxIGgDoMcpBXFdGIKxPUydcpFyadBpegzFjcA05yk8Sf)naksEL6agGkoGHThcJSVebn6CmfE2Mydt9hrpE1kWAqKujrMGnzrn5XHWi7lrqJohtHNRwj8zTSmKa8JmUTWLiOrNJPWZ2eByQ)i6XREKXdxEmfEwqh6Lg9SwIpB0E0lnwEkmY42D3lJiL0eq0BAwQbCzePKQihwcJuDB3dhUSlSpRLhtHNDvr(1ZAjcA05yk8SnXgM6pIE8QvG1GiPsImHr2B7EjcA05yk8C1kHpRLLHeGFK9LiOrNJPWZcgycblvcuWGj(GPbRhzFjcA05yk8Sf)naksEL6agGkoGHThcJSVebn6CmfE2I)gafjVsDXgeE(Wag2EimY(se0OZXu4zBInm1Fe94vpY4HllY7LVhfpYyH9LhtHNf0HEPrpRLrKsQICyjmsHcxgrkPjGO30Sud4WHl7QJN1sWW2dbcZ(WLXDHZA5Xu4zxvKF9SwIGgDoMcpBXFdGIKxPUydcpFyadBpegzFjcA05yk8C1kHpRLLHeGFICjve2DRI7GeORwLGeQIkcxvUK7klrqJohtHNfmWecwQeOGbt8btdwpY(se0OZXu4zl(BauK8k1bmavCadBpegzF4YJPWZc6qV0ON1YisjvroSegzS7LrKsAci6nnlLL4WHl7U7ZAjyy7HaHzF4YExGzT8yk8SRkYVEwlrqJohtHNT4VbqrYRuxSbHNpmGHThcJSVebn6CmfEwWatiyPsGcgmXhmny9i7TfUebn6CmfE2Mydt9hrpE1kWAqKujrMGnzrn5XHWi7TRuzjcA05yk8SnXgM6pIE8QvG1GiPsImHr2BlWse0OZXu4zBInm1Fe94vpY4LiOrNJPWZ2eByQ)i6XRoP8Je9kLORLOSQQS514i7lrqJohtHNT4VbqrYRuhWauXbmS9qyK9LiOrNJPWZvRe(Swwgsa(rgVebn6CmfE2Mydt9hrpE1kWAqKujrMGOqXEtZi7TRuz4YJPWZc6qV0ON1s0tHI1bZU4SVmIustarVPzPgWLrKsAWEZiJ7lJiLuf5WsyKQUeF2O9OxAS8uyKXT7UhoCP6E8Swcg2Eiqy2hUS3DpRLhtHNDvr(1ZAjcA05yk8Sf)naksEL6Ini88HbmS9qyK9LiOrNJPWZvRe(Swwgsa(rg3w4se0OZXu4zbdmHGLkbkyWeFW0G1JS3w4se0OZXu4zl(BauK8k1bmavCadBpegzF4YJPWZc6qV0ON1s8zJ2JEPXYtHrg3oEzePKMaIEtZsVzzePKQihwcJuGHdx2vlWSwcg2Eiqy2hUuypEwlpMcp7QI8RN1se0OZXu4zBInm1Fe94vpY(se0OZXu4zbdmHGLkbkyWeFW0G1JSVebn6CmfE2I)gafjVsDadqfhWW2dHr2xIGgDoMcpBXFdGIKxPUydcpFyadBpegzFjcA05yk8C1kHpRLLHeGFK9Hdx2fgpRLhtHNDvr(1ZAjcA05yk8SnXgM6pIE8QvG1GiPsImHr2B7EjcA05yk8Sf)naksEL6Ini88HbmS9qyK9LiOrNJPWZcgycblvcuWGj(GPbRhzFjcA05yk8Sf)naksEL6agGkoGHThcJSVebn6CmfEUALWN1YYqcWpY(se0OZXu4zBInm1Fe94vpY4HllY7LVhfpYy19LhtHNf0HEPrpRLrKsQICyjmsHcxgrkPjGO30Sud4WHl794zT8yk8SRkYVEwlrqJohtHNRwj8zTSmKa8JmUTWLiOrNJPWZw83aOi5vQl2GWZhgWW2dHr2xIGgDoMcplyGjeSujqbdM4dMgSEK9LiOrNJPWZw83aOi5vQdyaQ4ag2EimY(WLhtHNf0HEPrpRL4ZgTh9sJLNcJmEzePKMaIEtZsnGlJiLuf5WsyKvgoCzxOaZAjyy7HaHzF5Xu4zbDOxA0ZAzePKkYJeLAp6LMrwPVmIusd2BgzCFzePKMaIEtZYQ84YisjvKhTKnnHajtHIeYimfgoCz3D8Swcg2Eiqy2hUSxjEwlbdBpeim7dxQU3N1YJPWZc6qV0ON1s8zJ2JEPXYtHr2B7E5lrgHeq0BAwsaAEa0lJiL0eq0BAw6nlfZf1g08aOhPljqF5lrgHPWYisjvroSegP62Ux(sKrqb(C5NcdxEmfE2vf5xpRLiOrNJPWZ2eByQ)i6XRwbwdIKkjYegz8se0OZXu45QvcFwlldja)iDP42QUebn6CmfEwWatiyPsGcgmXhmny9iJxIGgDoMcpBXFdGIKxPoGbOIdyy7HWi7lrqJohtHNTj2Wu)r0JxDs5hj6vkrxlrzvvzZRXr2xIGgDoMcpBtSHP(JOhVAfynisQKitWMSOM84qyKXlrqJohtHNTj2Wu)r0Jx9iJxIGgDoMcpBtSHP(JOhVAfynisQKitquOyVPzK92vQmC4sH9(SwEmfE2vf5xpRLiOrNJPWZvRe(Swwgsa(r2xIGgDoMcplyGjeSujqbdM4dMgSEK9LiOrNJPWZw83aOi5vQdyaQ4ag2EimY(se0OZXu4zl(BauK8k1fBq45ddyy7HWi7lrqJohtHNTj2Wu)r0Jx9i7dxcUiCLiuTPyJhxI1EDBDrGWqD0cUGIwWfGqHQOwTaTIwiwDf3DvBfTqSQbPQAvBfTGBbeOxPv0cbjGkXb1kAb3UR0kAH4kQkGQQ0kAH4kQkqqb1kAHyvIf6wDROfC3dsfvAfTGQvcQ3kAbHcfwji3TIwiwLyHUv3kAbHcfq1kb1kAb3QJfO3kAb1UR4Uv0cQfkuL4wrlehKAvChuROfu7UIWwrlO2DfvAfTGA1vcQ3kAb1Uvj2DROfuluOkcBfTGabP2TQTIwiwLkcfq1wrlO2DL4wrliqqQDhuROfu7UsLwrlOQQQfqyROfuvv1ciqROfu7UI6wrleRwyfHQ0kAHy1cRimUv0cXQurOacBfTqCqc7Q6Uv0cXbjSRQaTIwqyCLECLwrlehKAvCRUv0ccvrvHciGlexULhtHNf0HEPrpRL4ZgTh9sJLNcJ09Yisjnbe9MMLEZsXCrTbnpa6rQUsF5lrgHeq0BAwsaAEa0lFjYimfwgrkPkYHLWify4sWfXN1ZAzTNa4cx8uy4WLX9(SwEmfE2vf5xpRLiOrNJPWZ2eByQ)i6XRwbwdIKkjYegzVT6LiOrNJPWZvRe(Swwgsa(jsfHD3Q4oib6QvjiHQ2vVQCj3QxIGgDoMcplyGjeSujqbdM4dMgSEK92cSebn6CmfE2I)gafjVsDadqfhWW2dHr2xIGgDoMcpBtSHP(JOhV6rgVebn6CmfE2Mydt9hrpE1kWAqKujrMGnzrn5XHWi7lrqJohtHNT4VbqrYRuxSbHNpmGHThcJSVebn6CmfE2Mydt9hrpE1jLFKOxPeDTeLvvLnVghPQTDpC5Xu4zbDOxA0ZAj(Sr7rV0y5PWiJxgrkPjGO30SuwIlJiLuf5WsyKXchoCzVsFwlbdBpeim7dx2vREwlbdBpeim7dhUKjOKnhqykmCjkUiWsBU6q0LvTOIDbhyPHPWYSUuxxsGzxO6OfkYdAaxYLyT8xM1L66scmpCd",
  },

  ["Vanillalike"] = {
    author = "mpstark",
    description = "Almost no ActionCam, mostly just nicities for zoom.",
    importString = "dCt2maGEvzxiuABiumteqnBPCte1TvANkAVu7wu)ui0Wu43KUmyOcvnoeqA4ivhuiDyuhtQY5ecYcrKLkeulwfwUepeHQNsSmK45QQjkuzQsAYQOPdDreqCvPIupdj56iOnIu2kczZcrSDKuFwLoTGPje13LkIrkvu)vQQrlvA8cLtke4wcr6AiqNxQWRrawRurYJfz3Zvl0lAKeAGRwkaNWa1qNs11vlqMpAWPjz0YjejmHnKiO8dA2ZEw(bKqgdA(7QLbvu5QfiZhn40hws8cfoAcdA(7QLNQlTaw17TbtEb6ngbtYYt1LmhZtkdJgTmOqLRwGmF0GtFyjXlu4OjmO5VRwEQU0cyvV3gm5fO3yemjlpvxYCmpPmmA0YyqmUAbY8rdo9HLeVqHJMWGM)UA5P6kaIH81YhqJgTq1GIRws8cfM4eXLVRwq4J9t8cfoUoY8gsXhWuxs8hOPuhpF65Gyh9SGWh7N4fkCCDK5nKIpGPUE2ZccFSFIxOWrKAOiDvcBNqXZiThXsqli8X(jEHchxhzEdP4dyQlj(d0uQJNpJt7KSK4g45GyPIGgTK4fkC0eg083vlpvxbqmKVw(aA5P6slGv9EBWKxGEJrWKS8uDjZX8KYWshCNehCla89ms7nSuuKrqaed5RLt4wa4B5P6se3ie8KGwkkYiqIteGjz0OLbXmC1cK5JgC6dljEHchnHbn)D1Yt1LwaR692GjVa9gJGjz5P6sMJ5jLHrJwgdkUAjXlu4OjmO5VRwEQU0cyvV3gm5fO3yemjlpvxbqmKVwczlpvxI4gHGNeOwEQUK5yEszy0OLEJHRws8cfM4eXLVRwq4J9t8cfoUoY8gsXhWuxphwq4J9t8cfUZaFswPgwiJcwG8f765WccFSFIxOWrKAOiDvcBNqXZHrljEHchnHbn)D1Yt1LwaR692GjVa9gJGjz5P6kaIH81IsiA5P6se3ie8KkcA5P6sMJ5jLHrJwOmgUAjXluyItex(UAbHp2pXlu446iZBifFatD9CybHp2pXlu4od8jzLAyHmkybYxSRNdli8X(jEHchrQHI0vjSDcfphgTK4fkC0eg083vlpvxYCmpPmS8uDfaXq(AjKTGfo)dyqZ1WcE2ByPOiJGjz5P6se3ie8mYw6G7K4GBbGVNurmdlffzeeaXq(A5eUfa(wWWcrWNmhZhwEQU0cyvV3gm5fO3yemjJwGyyH)UAPB4e60rGjz0OLEdkUAjXluyItex(UAbHp2pXlu4isnuKUkHTtO45WccFSFIxOWDg4tYk1WczuWcKVyxphwq4J9t8cfoUoY8gsXhWuxphgTK4fkC0eg083vlpvxAbSQ3BdM8c0BmcMKLNQlzoMNuggnAzqWHRwGmF0GtFyjXlu4OjmO5VRwEQU0cyvV3gm5fO3yemjlpvxYCmpPmmA0YGQEUAbY8rdo9HLeVqHJMWGM)UA5P6slGv9EBWKxGEJrWKS8uDjZX8KYWOrlun65QfiZhn40hws8cfoAcdA(7QLNQlTaw17TbtEb6ngbtYYt1vaed5RLq2Yt1LiUri4zKT8uDjZX8KYWOrlJbbD1sIxOWrtyqZFxT8uDfaXq(AjKT8uDPfWQEVnyYlqVXiyswEQUK5yEszy0OLEJEUAjXluyItex(UAbHp2pXlu4od8jzLAyHmkybYxSRNdli8X(jEHchrQHI0vjSDcfphgTK4fkC0eg083vlpvxAbSQ3BdM8c0BmcMKLNQRaigYxlFaT8uDjIBecEsveYYt1LmhZtkdJgTqz0ZvljEHctCI4Y3vli8X(jEHchxhzEdP4dyQRNdli8X(jEHc3zGpjRudlKrblq(ID9CybHp2pXlu4isnuKUkHTtO45WOLeVqHJMWGM)UA5P6slGv9EBWKxGEJrWKS8uDjZX8KYWOrldIPNRwGmF0GtFyjXlu4OjmO5VRwEQU0cyvV3gm5fO3yemjlpvxYCmpPmmA0Yy0ZvljEHchnHbn)D1Yt1vaed5RLcNVGLNQl5q2ZEdlpvxAbSQ3BdM8c0BmcMKLNQlzoMNuggnAzqjYUAbY8rdo9HLeVqHJMWGM)UA5P6slGv9EBWKxGEJrWKS8uDjZX8KYWOrldc2ZvlqMpAWPpSK4fkC0eg083vlpvxAbSQ3BdM8c0BmcMKLNQlzoMNuggnAzmISRws8cfoAcdA(7QLNQRaigYxlfoFblpvxYHSN9iOLNQlTaw17TbtEb6ngbtYYt1LmhZtkdJgTq1y4QLeVqHjorC57Qfe(y)eVqHJRJmVHu8bm11ZEgTGC5cibwteGRwGmF0GttYIMBDefrora8rd8HLmVa9gJarHF4Ob(WOLeVqHJMWGM)UA5P6slGrqovGfY43ZbXsqlpvxbqmKVwIKaA5P6sMJ5jvdlpvxAbmE9hWGM9mcnS8uDjhYEsLLNQlrCJqWZiB5P6slGv9EBWKxGEJrWKmAbY8rdo9HrldkdxTaz(ObN(WsIxOWrtyqZFxT8uDPfWQEVnyYlqVXiyswEQUK5yEszy0OLbvdxTaz(ObN(WsIxOWrtyqZFxT8uDPfWQEVnyYlqVXiyswEQUK5yEszy0OLbvr2vlqMpAWPpSK4fkC0eg083vlpvxAbSQ3BdM8c0BmcMKLNQlzoMNuggnAzqPNRwGmF0GtFyjXlu4OjmO5VRwEQU0cyvV3gm5fO3yemjlpvxYCmpPmmA0Of(KAoNGttYOfSd6GL4iE)4JWrKweqGjqSK5fSqeNdTghPTabawycXUAXYs)JCHamAda",
  },
}


function DynamicCam:LoadPreset(defaultName)
  -- if there is a preset with this name, then load it into the current profile
  if presets[defaultName] then
    self:ImportIntoCurrentProfile(presets[defaultName].importString)
  end
end

function DynamicCam:GetPresets()
  local presetList = {}

  -- load a table full of the name (the key) and what we want the entry to read
  for name, tbl in pairs(presets) do
    local entry = string.format("%s (%s)", name, tbl.author)
    presetList[name] = entry
  end
  return presetList
end


function DynamicCam:GetPresetsSorting()
  local presetSortingList = {}

  local index = 1
  -- load a table full of the name (the key) and what we want the entry to read
  for name in pairs(presets) do
    presetSortingList[index] = name
    index = index + 1
  end
  return presetSortingList
end



function DynamicCam:GetPresetDescriptions()
  local descriptions = ""
  local sep = ""

  -- load a table full of the name (the key) and what we want the entry to read
  for name, tbl in pairs(presets) do
    local entry = string.format("%s|cFFFFFF00%s (%s):|r\n%s", sep, name, tbl.author, tbl.description)
    descriptions = descriptions..entry
    sep = "\n\n"
  end

  return descriptions
end
